<?php
/* --------------------------------------------------------------
   AllTrackingCodesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeSqlCriteria;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeSqlPagination;

/**
 * Class AllTrackingCodesRequested
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class AllTrackingCodesRequested
{
    /**
     * @var TrackingCodeSqlCriteria
     */
    private $criteria;
    
    
    /**
     * @var TrackingCodeSqlPagination
     */
    private $pagination;
    
    
    /**
     * AllTrackingCodesRequested constructor.
     *
     * @param TrackingCodeSqlCriteria   $criteria
     * @param TrackingCodeSqlPagination $pagination
     */
    private function __construct(
        TrackingCodeSqlCriteria $criteria,
        TrackingCodeSqlPagination $pagination
    ) {
        $this->criteria   = $criteria;
        $this->pagination = $pagination;
    }
    
    
    /**
     * @param TrackingCodeSqlCriteria   $criteria
     * @param TrackingCodeSqlPagination $pagination
     *
     * @return AllTrackingCodesRequested
     */
    public static function create(
        TrackingCodeSqlCriteria $criteria,
        TrackingCodeSqlPagination $pagination
    ): AllTrackingCodesRequested {
        return new self($criteria, $pagination);
    }
    
    
    /**
     * @return TrackingCodeSqlCriteria
     */
    public function criteria(): TrackingCodeSqlCriteria
    {
        return $this->criteria;
    }
    
    
    /**
     * @return TrackingCodeSqlPagination
     */
    public function pagination(): TrackingCodeSqlPagination
    {
        return $this->pagination;
    }
    
    
    /**
     * @param TrackingCodeSqlCriteria $criteria
     */
    public function replaceCriteria(TrackingCodeSqlCriteria $criteria): void
    {
        $this->criteria = $criteria;
    }
    
    
    /**
     * @param TrackingCodeSqlPagination $pagination
     */
    public function replacePagination(TrackingCodeSqlPagination $pagination): void
    {
        $this->pagination = $pagination;
    }
}